#include "stdafx.h"
#include "RwBonesPro.h"
#include "utilities.h"
#include "BonesPro.h"

RwBonesProExport::RwBonesProExport(INode *NewSkinNode)
{
    SkinNode=NewSkinNode;
    SkinModifier=FindModifier( SkinNode, BP_CLASS_ID_WSM );
    if (!SkinModifier) SkinModifier=FindModifier( SkinNode, BP_CLASS_ID_OSM );
}

void
RwBonesProExport::MakeBoneNodeList(void)
{
//Find all the bones referenced by this skin and hold pointers to the INodes
    int i;
    BonesPro_Bone Bone;
    
    //SkinModifier->SetProperty(BP_PROPID_GET_N_BONES,&NumBones);
    for (i=0; i<NumBones; i++)
    {
        Bone.t=BP_TIME_ATTACHED;
        Bone.index = i;
        SkinModifier->SetProperty(BP_PROPID_GET_BONE,&Bone);
        BoneNodeList.push_back(Bone.node);
        char temp[256];
        sprintf(temp,"Bone %i=0x%x\n",i,BoneNodeList[i]);
        OutputDebugString(temp);
        //sprintf(temp,"size=%i\n",BoneNodeList.size());
        //OutputDebugString(temp);
    }
    //char temp[256];
    //sprintf(temp,"size=%i\n",BoneNodeList.size());
    //OutputDebugString(temp);
}

void
RwBonesProExport::MakeVertexBoneWeightMap(void)
{
//build a list of all the bones and their vertex assignments
//POST: a list in VertexList, BoneNumberList and WeightList for every
//bone in every vertex in the model that has a non-zero weight.
    int i,bonenum,j;
                
    /* now get data from bonesPro modifier  */
    if (SkinModifier)
    {
        /* Get access to bone info */
        BonesPro_WeightArray *bp_weightArray = NULL;
        SkinModifier->SetProperty( BP_PROPID_GET_WEIGHTS, &bp_weightArray );
        NumBones=bp_weightArray->nb;
        MakeBoneNodeList();
        
        // build a list of all the bone/vertex connections and their weights
        for (i = 0; i < remapper->GetNumVertices(); i++)
        {
            int vertexIndex = remapper->GetVertex(i)->vertexIndex;
            
            for (bonenum=0; bonenum<NumBones; bonenum++) {
                //bp_weightarray is an array of one weight per bone for every vertex
                //bp_weightarray->nb is the number of bones
                float Weight = bp_weightArray->w[(vertexIndex * bp_weightArray->nb) + bonenum];                    

                if (Weight!=0.0f)
                {
                    BonesPro_Bone  bone;
                    bone.t     = BP_TIME_ATTACHED;
                    bone.index = bonenum;
                    //get the bone for this weight number
                    SkinModifier->SetProperty( BP_PROPID_GET_BONE, &bone );

                    //find the bone number by checking the returned INode against
                    //the list of INodes in BoneNodeList to find the index number
                    //this is not the same as bonenum
                    for (j=0; j<BoneNodeList.size()/*or NumBones*/; j++)
                    {
                        if (BoneNodeList/*was boneindexnodepointers*/[j]==bone.node)
                        {
                            //add new entries to the end of the lists
                            VertexList.push_back(vertexIndex);
                            BoneNumberList.push_back(j);
                            WeightList.push_back(Weight);
                        }
                    }
                }
            }
        }
    }                         
}
